<?php
class UsbxErrorCodeManager {
    static private $xml = null ;

    static function load() {
        if( file_exists( Constants::USBX_ERROR_CODE_XML_FILE ) == false ) {
            throw new Exception( 'FileNotExist: ' . Constants::USBX_ERROR_CODE_XML_FILE ) ;
        }

        if( self::$xml === null  ) {
            self::$xml = simplexml_load_file( Constants::USBX_ERROR_CODE_XML_FILE ) ;
        }
    }
    
    static function isExist( $xpath ) {
        self::load() ;
        
        $values = self::$xml -> xpath( $xpath ) ;
        if( count( $values ) == 0 ) {
            return false ;
        }
        
        return true ;
    }
    
    static function get( $xpath, $index = 0 ) {
        self::load() ;

        if( self::isExist( $xpath ) == false ) {
            throw new Exception( "XpathNotExist: $xpath" ) ;
        }
        
        $values = self::$xml -> xpath( $xpath ) ;
        return $values[ $index ] ;
    }
    
    static function set( $xpath, $value ) {
        self::load() ;
        
        if( self::isExist( $xpath ) == true ) {
            self::update( $xpath, $value ) ;
        }
        
        else {
            self::add( $xpath, $value ) ;
        }
    }

    static function setToXml( $xpath, $value ) {
    }
    
    static function reload() {
        if( file_exists( Constants::USBX_ERROR_CODE_XML_FILE ) == false ) {
            throw new Exception( 'FileNotExist: ' . Constants::USBX_ERROR_CODE_XML_FILE ) ;
        }
        
        self::$xml     = simplexml_load_file( Constants::USBX_ERROR_CODE_XML_FILE ) ;
    }
    
    static function getErrorDesc( $code ) {
        $result = $entry = array() ;
        try {
            $entry = self::get( "/UsbxErrorCode/Set[@error_code='$code']" ) ;
            $result = $entry->Message;
            if( !empty($entry->PossibleAction) )
                $result .= ': ' . $entry->PossibleAction;
        }
        
        catch( Exception $e ) {
            $msg = $e -> getMessage() ;
            CommonUtility::debug_print( $msg ) ;
            return '' ;
        }
        
        return $result ;
    }
}

if( realpath( $_SERVER[ 'SCRIPT_NAME' ] ) == realpath( __FILE__ ) ) {
    require_once( 'Constants.class.php' ) ;
    
    try {
        echo UsbxErrorCodeManager::getErrorDesc( 20 );
    }
    
    catch ( Exception $e ) {
        echo '[' . $e -> getFile() . '(' . $e -> getLine() . ')]: ' . $e -> getMessage() . '\n' ;
    }
}
